/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.parser.phpdoc;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import org2.eclipse.php.util.StringUtils;

public abstract class DocumentationBase {
    private static final String[] NO_STRINGS = new String[0];
    private String fAuthor = "";
    private String fName = "";
    private String fDescription = "";
    private String fVersion = "";
    private ArrayList<String> fSees;
    private ArrayList<String> fSDocLocations;
    private int fType = 1;
    private ArrayList<String> fExamples;
    private String fRemarks = "";
    private String userAgent = "";

    public String getName() {
        return this.fName;
    }

    public void setName(String value) {
        this.fName = value == null ? "" : value;
    }

    public String getDescription() {
        return this.fDescription;
    }

    public void setDescription(String value) {
        this.fDescription = value == null ? "" : value;
    }

    public String getRemarks() {
        return this.fRemarks;
    }

    public void setRemarks(String value) {
        this.fRemarks = value == null ? "" : value;
    }

    public String getAuthor() {
        return this.fAuthor;
    }

    public void setAuthor(String value) {
        this.fAuthor = value == null ? "" : value;
    }

    public String getVersion() {
        return this.fVersion;
    }

    public void setVersion(String value) {
        this.fVersion = value == null ? "" : value;
    }

    public String[] getSees() {
        if (this.fSees == null) {
            return NO_STRINGS;
        }
        return this.fSees.toArray(NO_STRINGS);
    }

    public void addSee(String value) {
        String string = value = value == null ? "" : value;
        if (this.fSees == null) {
            this.fSees = new ArrayList();
        }
        this.fSees.add(value);
    }

    public int getDocumentType() {
        return this.fType;
    }

    public void setDocumentType(int type) {
        this.fType = type;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public void read(DataInput input) throws IOException {
        this.fAuthor = input.readUTF();
        this.fName = input.readUTF();
        this.fDescription = input.readUTF();
        this.addExample(input.readUTF());
        this.fRemarks = input.readUTF();
        this.fVersion = input.readUTF();
        int size = input.readInt();
        if (size > 0) {
            this.fSees = new ArrayList();
            int i = 0;
            while (i < size) {
                this.fSees.add(input.readUTF());
                ++i;
            }
        }
    }

    public void write(DataOutput output) throws IOException {
        output.writeUTF(this.fAuthor);
        output.writeUTF(this.fName);
        output.writeUTF(this.fDescription);
        output.writeUTF(StringUtils.join((String)"\n\n", (String[])this.getExamples()));
        output.writeUTF(this.fRemarks);
        output.writeUTF(this.fVersion);
        if (this.fSees != null) {
            output.writeInt(this.fSees.size());
            int i = 0;
            while (i < this.fSees.size()) {
                output.writeUTF(this.fSees.get(i));
                ++i;
            }
        } else {
            output.writeInt(0);
        }
    }

    public void addSDocLocation(String value) {
        String string = value = value == null ? "" : value;
        if (this.fSDocLocations == null) {
            this.fSDocLocations = new ArrayList();
        }
        this.fSDocLocations.add(value);
    }

    public String[] getSDocLocations() {
        if (this.fSDocLocations == null) {
            return NO_STRINGS;
        }
        return this.fSDocLocations.toArray(NO_STRINGS);
    }

    public String[] getExamples() {
        if (this.fExamples != null) {
            return this.fExamples.toArray(NO_STRINGS);
        }
        return NO_STRINGS;
    }

    public void addExample(String value) {
        if (value == null) {
            return;
        }
        if (this.fExamples == null) {
            this.fExamples = new ArrayList();
        }
        this.fExamples.add(value);
    }
}

